﻿var $txtTrxId;
var $txtProyectoName;
var $lblProyectoName;
var $txtUsId;
var $txtProyectoId;
var $txtFileUploadName;
var $txtProcesoId;
var $txtSQLServer;
var $lblSQLServer;
var $txtSQLAutenticacion_userpass;
var $txtSQLUserId;
var $txtSQLUserPassword;
var $cboDataBases;
var $lblBDName;
var $txtOrigenDeDatos;
var $txtOrigenDeDatosId;
var $cboTablas;
var $tableAtributeMapping;
var $txtAtributosDeTablas;
var $txtAtributosDePectra;
var $btnCrearProyecto;
var $btnCrearProceso;
var $btnConectarBDServer;
var $btnGenerarBackEnd;
var $btnGenerarApp;
var $btnNuevaActividad;
var $divDD;
var $divActividades;
var $divGeneracionApp;
var $btnBackup;
var $btnGuardarDD;
var $btndownloadEnabled;
var $btndownloadDisabled;

var $txtActividades;
var _tablaAttibutos;
var _tableActivities
var mShowDataTablaAttributos = false;
var $msgProcessing;

var regEx_FileName = "^[a-zA-Z0-9\-\.\s \()\_\+]+$";

function setearProyecto(idProyecto) {
    $txtProyectoId.val(idProyecto);
}

function setearProceso(idProceso) {
    $txtProcesoId.val(idProceso);
    habilitarDescargarProceso();
}

function setearDBs(databases) {
    $cboDataBases.children('option').remove();

    if (databases.length > 0) {

        $cboDataBases.show();
        $lblBDName.hide();
        var dbSelected = $lblBDName.val()
        $cboDataBases.removeAttr("disabled");
        $.each(databases, function (key, value) {
            if (dbSelected == value)
                $cboDataBases.append('<option value=' + value + ' selected>' + value + '</option>');
            else
                $cboDataBases.append('<option value=' + value + '>' + value + '</option>');
        });
    }
}

function habilitarDescargarProceso() {
    $btndownloadEnabled.show();
    $btndownloadDisabled.hide();
}

function crearProyecto() {

    if ($txtProyectoName.val() == '') {
        showMessage(3, "Ingrese el nombre del proyecto");
        return false;
    }
    var param = {};
    param.name = $txtProyectoName.val();
    param.usrid = $txtUsId.val();

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/CrearProyecto",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
        },
        success: function (result) {

            $txtProyectoName.prop('disabled', true);
            $btnCrearProyecto.hide();
            setearProyecto(result.d);
            $btnCrearProceso.show();
            showMessage(1, "Proyecto creado");

            if ($txtProcesoId.val() == '')
                $('#mdlFileUpload').modal('show');
        }
    });
}

function adjuntarProceso() {
    var name = $txtFileUploadName.val();
    var files = $("#fileToUpload").get(0).files;

    if (files.length < 1) {
        alert('Debe seleccionar un archivo');
        return false;
    }

    var oFormData = new FormData();
    oFormData.append("FileToUpload", files[0]);
    oFormData.append("FileName", name);
    oFormData.append("ProjectId", $txtProyectoId.val());
    oFormData.append("ProcessId", $txtProcesoId.val());

    $.ajax({
        url: "../api/fileupload/AdjuntarProceso",
        data: oFormData,
        dataType: 'json',
        type: 'POST',
        contentType: false,
        processData: false,
        success: function (data) {
            if (data !== "") {
                showMessage(1, "Proceso adjuntado");
                $lblFileUploadName.val($txtFileUploadName.val());
                setearProceso(data);
                $btndownloadEnabled.show();
                $btndownloadDisabled.hide();
                $btnConectarBDServer.show();

                if ($txtOrigenDeDatos.val() == '') {
                    $('#mdlBDServer').modal('show');
                    $txtSQLServer.focus();
                }

                obtenerActividades();
            }
            else {
                showMessage(2, "Se produjo un error. Intente nuevamente.");
            }
        },
        error: function (errorData) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
        }
    });
}

function asignarNombreArchivo(src) {
    var fullname = $(src).val().split('\\').pop();

    if (fullname != '' && fullname.indexOf('.') > 0) {
        arrname = fullname.split('.');
        var extension = arrname[arrname.length - 1];
        extension = (extension + '').toLowerCase();
        if (extension != 'pbp' && extension != 'pbpx') {
            alert("El formato del archivo no esta permitido");
            fullname = "";
        }
    }
    $txtFileUploadName.val(fullname);

}

function descargarProceso() {

    var idProceso = $txtProcesoId.val()
    var xhr = new XMLHttpRequest();
    xhr.open('GET', "../api/fileupload/DescargarProceso?idProceso=" + idProceso, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function () {
        if (this.status === 200) {
            var filename = "";
            var disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(disposition);
                if (matches != null && matches[1])
                    filename = decodeURIComponent(matches[1].replace(/['"]/g, ''));
            }
            var type = xhr.getResponseHeader('Content-Type');

            var blob = typeof File === 'function'
                ? new File([this.response], filename, { type: type })
                : new Blob([this.response], { type: type });
            if (typeof window.navigator.msSaveBlob !== 'undefined') {
                // IE workaround for "HTML7007: One or more blob URLs were revoked by closing the blob for which they were created. These URLs will no longer resolve as the data backing the URL has been freed."
                window.navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                var URL = window.URL || window.webkitURL;
                var downloadUrl = URL.createObjectURL(blob);

                if (filename) {
                    // use HTML5 a[download] attribute to specify filename
                    var a = document.createElement("a");
                    // safari doesn't support this yet
                    if (typeof a.download === 'undefined') {
                        window.location = downloadUrl;
                    } else {
                        a.href = downloadUrl;
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                    }
                } else {
                    window.location = downloadUrl;
                }

                setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
            }
        }
    };
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send(null);
    return;
}

function getDBParam() {
    var param = {};

    param.sidproyecto = $txtProyectoId.val();
    param.dbserver = $txtSQLServer.val();

    if ($cboDataBases.is(":visible")) {
        $lblBDName.val($cboDataBases.val())
    }
    if ($lblBDName.val() != null) {
        param.dbname = $lblBDName.val();
    }
    else {
        param.dbname = "";
    }
    if ($txtSQLAutenticacion_userpass.prop("checked")) {
        param.dbuseintegrated = "0";
        param.dbuserid = $txtSQLUserId.val();
        param.dbuserpassword = $txtSQLUserPassword.val();
    }
    else {
        param.dbuseintegrated = "1";
        param.dbuserid = "";
        param.dbuserpassword = "";
    }

    return param;
}

function dbConectar() {

    if ($txtSQLServer.val() == '') {
        showMessage(2, "Ingrese el nombre del servidor.");
        $txtSQLServer.focus();
        return;
    }
    if ($txtSQLAutenticacion_userpass.prop("checked")) {
        if ($txtSQLUserId.val() == '') {
            showMessage(2, "Ingrese el nombre del usuario.");
            $txtSQLUserId.focus();
            return;
        }
        if ($txtSQLUserPassword.val() == '') {
            showMessage(2, "Ingrese la contraseña.");
            $txtSQLUserPassword.focus();
            return;
        }
    }
    var param = getDBParam();
    $('#mdlBDServer').modal('hide');
    $lblProcesandoSolicitud.html("Intentando conectar al motor de dase de datos.....")
    $msgProcessing.show()

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/GetBasesDeDatos",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            eestop();
            $msgProcessing.hide();
            $('#mdlBDServer').modal('show');
        },
        success: function (result) {
            showMessage(1, "Conexión exitosa");
            setearDBs(JSON.parse(result.d).BasesDeDatos);
            $lblSQLServer.val($txtSQLServer.val())
            $btnGenerarBackEnd.show();
            eestop();
            $msgProcessing.hide()
        }
    });
}

function dbGenerarBackEnd(bDoFront) {

    if (bDoFront) {
        if (!TodosFormulariosOk()) {

            showMessage(2, "Existen formularios con campos mal configurados.");
            return;
        }
    }

    var param = getDBParam();
    param.sidproceso = $txtProcesoId.val();
    param.proyectname = $txtProyectoName.val();
    param.sorigendedatosid = $txtOrigenDeDatosId.val();

    $lblProcesandoSolicitud.html("Generando BackEnd.....")
    $msgProcessing.show()

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/CrearBaseDeDatos",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //alert("Request: " + XMLHttpRequest.toString() + "\n\nStatus: " + textStatus + "\n\nError: " + errorThrown);
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            eestop();
            $msgProcessing.hide()
        },
        success: function (result) {
            showMessage(1, "Generación de backend exitosa");

            if (bDoFront)
                generarFrontEnd();
            else {
                $cboDataBases.hide();
                $lblBDName.show();
                setearTablas(result.d)
                $divDD.show();
                $divActividades.show();
                $divGeneracionApp.show();
                $btnBackup.show();
                $btnGenerarApp.show();
                $btnNuevaActividad.show()
                eestop();
                $msgProcessing.hide()
            }
        }
    });
}

function obtenerAtributos() {
    var param = getDBParam();
    param.sidproceso = $txtProcesoId.val();

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/ObtenerAtributos",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
        },
        success: function (result) {
            setearAtributos(result);
        }
    });
}

function setearAtributos(result) {
    if (result != null) {
        $txtAtributosDeTablas.val(JSON.stringify(JSON.parse(result.d).DB))
        $txtAtributosDePectra.val(JSON.stringify(JSON.parse(result.d).Pectra))

        llenarTablaAtributos();
        obtenerActividades();
    }
}

function setearTablas(data) {

    var tables = JSON.parse(data);

    $cboTablas.children('option').remove();
    var origenDeDatosId = 0;


    if (data.length > 0) {

        $cboTablas.removeAttr("disabled");
        $btnGuardarDD.show();

        $.each(tables, function (key) {
            $cboTablas.append('<option value=' + tables[key].IdOrigenDeDatosTabla + '>' + tables[key].NombreTabla + '</option>');
            if (origenDeDatosId == 0)
                origenDeDatosId = tables[key].IdOrigenDeDatos;
        })
    }

    if (origenDeDatosId != 0) {
        $txtOrigenDeDatosId.val(origenDeDatosId);
        $txtOrigenDeDatos.val(data);
        obtenerAtributos();
    }
}

function obtenerActividades() {
    if ($txtAtributosDeTablas.val() == "")
        return;

    var param = {};
    param.sidproceso = $txtProcesoId.val();

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/GetActividades",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            $msgProcessing.hide()
        },
        success: function (result) {
            $txtActividades.val(result.d)
            setearActividades();
        }
    });
}

function ConfirmaEliminarActividad(ActId, ActName) {
    bootbox.dialog({
        title: "Eliminación de Actividad",
        message: "¿Está seguro que desea eliminar la actividad </br> <b>" + ActId + " - " + ActName + "<b> ?",
        backdrop: true,
        buttons: {
            si: {

                label: '<i class="fa fa-check"></i> Si',
                className: 'btn-success',
                callback: function () {
                    EliminarActividad(ActId);
                }
            },
            no: {
                label: '<i class="fa fa-times"></i> No',
                className: 'btn-danger'
            }
        }
    });
    return;
}

function EliminarActividad(ActId) {
    var param = {};
    param.sidActividad = ActId;
    $msgProcessing.show();
    $.ajax({
        type: "POST",
        url: "EditProject.aspx/EliminarActividad",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            $msgProcessing.hide()
        },
        success: function (result) {
            showMessage(1, "Eliminación exitosa");
            obtenerActividades();
        }
    });
}

function showNotAllowActividad() {
    showMessage(3, "Esta actividad pertenece al proceso y no puede ser eliminada.");
}

function setearActividades() {
    llenarTablaActividades();
}

function EditarActividad(idActividad) {
    var url = "../Default.aspx?PantallaApertura=DiseniarFormulario&TrxId=0&ActId=" + idActividad + "&IdProyecto=" + $txtProyectoId.val();
    var myWindow = window.open(url, "MsgWindow", "width=1000,height=650,resizable=1");
}

function NuevaActividad() {
    var param = getDBParam();
    param.sidproject = $txtProyectoId.val();

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/CrearFormulario",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
        },
        success: function (result) {
            if (result.d != "" && result.d != "0") {
                EditarActividad(result.d)
            }
            else {
                showMessage(2, "Se produjo un error. Intente nuevamente.");
            }
        }
    });
}

function TodosFormulariosOk() {
    var tabla = $('#tableActivities').DataTable();
    var todosValidos = true;
    tabla.rows().every(function (rowIdx, tableLoop, rowLoop) {
        if (this.data().Estado == false)
            todosValidos = false;
    });
    return todosValidos;
}

function showCamposError(campos, cant) {
    if (cant > 1)
        showMessage(2, "Corrija los siguientes campos: " + "<br/>" + campos);
    else
        showMessage(2, "Corrija el siguiente campo: " + "<br/>" + campos);
}

function llenarTablaActividades() {

    if ($txtActividades.val() == '')
        return;

    try {

        var oActividades = JSON.parse($txtActividades.val());

        $('#tableActivities').DataTable().clear();
        $('#tableActivities').DataTable().destroy();

        _tableActivities = $("#tableActivities").DataTable({
            data: oActividades,
            "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
            "paging": false,//Dont want paging                
            "bPaginate": false,//Dont want paging   
            "columnDefs": [
            { width: '20%', targets: 3, className: 'cellC' },
            { width: '50%', targets: 4 },
            { width: '10%', targets: 5, className: 'cellC' },
            { width: '10%', targets: 6, className: 'cellC' },
            { width: '5%', targets: 7, className: 'cellC' },
            { width: '5%', targets: 8, className: 'cellC' }
            ],
            "columns": [
                { name: 'IdActividad', "data": 'IdActividad', title: "IdActividad", sortable: false, visible: false },
                { name: 'IdProceso', "data": 'IdProceso', title: "IdProceso", visible: false },
                { name: 'IdFormulario', "data": 'IdFormulario', title: "IdFormulario", sortable: false, searchable: false, visible: false },
                {
                    name: 'IdActividadPectra', "data": 'IdActividadPectra', title: "Actividad Nro.", sortable: false, searchable: false,
                    render: function (data, type, row) {
                        if (type === 'display') {
                            if (row.IdActividadPectra != null && row.IdActividadPectra > 0)
                                return data;
                            else
                                return '-';
                        }
                        return data;
                    }
                },
                { name: 'DescripcionActividadPectra', "data": 'DescripcionActividadPectra', title: "Descripción de la Actividad", sortable: false, searchable: false },
                 {
                     name: 'CuentaConFormulario', "data": null, title: "Formulario disponible", sortable: false, searchable: false,
                     render: function (data, type, row) {
                         if (type === 'display') {
                             if (row.IdFormulario != null && row.IdFormulario > 0)
                                 return '<i class="fa fa-check-circle fa-lg text-success" id="ieditar" alt="si"></i>';
                             else
                                 return '<i class="fa fa-circle-o fa-lg" id="ieditar" alt="no"></i>';
                         }
                         return data;
                     }
                 },
                 {
                     name: 'Estado', "data": null, title: "Estado", sortable: false, searchable: false,
                     render: function (data, type, row) {
                         if (type === 'display') {
                             if (row.Estado != null && row.Estado == true)
                                 return "";
                                 //return '<i class="fa fa-check-circle fa-lg text-success" id="ieditar" alt="ok"></i>';
                             else {
                                 var campos = "";
                                 for (var i = 0; i < row.AtributosConError.length; i++) {
                                     if (campos != "")
                                         campos = campos + "<br/>";
                                     campos = campos + row.AtributosConError[i];

                                 }
                                 return '<i class="fa fa-exclamation-circle fa-lg" style="color:red;cursor: pointer" id="ieditar" alt="error" onclick="showCamposError(\'' + campos + '\', ' + row.AtributosConError.length + ')"></i>';
                             }
                         }
                         return data;
                     }
                 },
                {
                    name: 'Edition', "data": null, title: "Editar", sortable: false, searchable: false,
                    render: function (data, type, row) {
                        if (type === 'display') {
                            return '<a class="btn btn-primary" href="" aria-label="Configurar Actividad" onclick="EditarActividad(' + row.IdActividad + ');return false">' +
                                       '<i class="fa fa-wpforms" aria-hidden="true"></i></a>'
                        }
                        return data;
                    }
                },
                {
                    name: 'Eliminar', "data": null, title: "Borrar", sortable: false, searchable: false,
                    render: function (data, type, row) {
                        if (type === 'display') {
                            if (row.IdActividadPectra == null || row.IdActividadPectra == 0)
                                return '<a class="btn btn-danger" href="" aria-label="Eliminar Actividad" onclick="ConfirmaEliminarActividad(' + row.IdActividad + ', \'' + row.DescripcionActividadPectra + '\');return false">' +
                                       '<i class="fa fa-trash-o" aria-hidden="true"></i></a>'
                            else
                                return '<a class="btn btn-danger fa-disabled" href="" onclick="showNotAllowActividad();return false">' +
                                       '<i class="fa fa-ban" aria-hidden="true"></i></a>'
                        }
                        return '';
                    }
                }

            ]
        });
    } catch (e) {
        showMessage(2, "Se produjo un error. Intente nuevamente.");
        $msgProcessing.hide()
    }


    FiltrarAtributos();
    $msgProcessing.hide()
}

function cambiarAttPectra(idAttibuto, src) {
    for (var i = 0; i < _tablaAttibutos.rows().count() ; i++) {
        if (_tablaAttibutos.cell(i, 0).data() == idAttibuto) {
            _tablaAttibutos.cell(i, 6).data(src.value);
            return;
        }
    }
}

function llenarTablaAtributos() {

    if ($txtAtributosDeTablas.val() == '')
        return;

    try {
        var oAttTablas = JSON.parse($txtAtributosDeTablas.val());
        var oAttPectra = JSON.parse($txtAtributosDePectra.val());

        $('#tableAtributeMapping').DataTable().clear();
        $('#tableAtributeMapping').DataTable().destroy();

        _tablaAttibutos = $("#tableAtributeMapping").DataTable({
            data: oAttTablas,
            "bInfo": false, //Dont display info e.g. "Showing 1 to 4 of 4 entries"
            "paging": false,//Dont want paging                
            "bPaginate": false,//Dont want paging      
            "bFilter": true,
            "searching": true,
            "preDrawCallback": function (settings) {
                return mShowDataTablaAttributos;   //Evita que la primera vez se cargue ya que no tiene seleccionada la tabla
            },
            "columnDefs": [
                { width: '32%', targets: 2 },
                { width: '15%', targets: 3 },
                { width: '10%', targets: 4, className: 'cellC' },
                { width: '10%', targets: 5, className: 'cellC' },
                { width: '33%', targets: 6 }
            ],

            "columns": [
                { name: 'IdAtributo', "data": 'IdAtributo', title: "IdAtributo", sortable: false, visible: false },
                { name: 'IdOrigenDeDatosTabla', "data": 'IdOrigenDeDatosTabla', title: "IdOrigenDeDatosTabla", visible: false },
                { name: 'Nombre', "data": 'Nombre', title: "Campo", sortable: false, searchable: false },
                { name: 'TipoDeDato', "data": 'TipoDeDato', title: "Tipo de dato", sortable: false, searchable: false },
                {
                    name: 'PermiteNulo', "data": 'PermiteNulo', title: "Admite NULL", sortable: false, searchable: false,
                    render: function (data, type, row) {
                        if (type === 'display') {
                            if (data == "1")
                                return '<i class="fa fa-check-circle fa-lg text-success" id="ieditar" alt="si"></i>';
                            else
                                return '<i class="fa fa-circle-o fa-lg" id="ieditar" alt="no"></i>';
                        }
                        return data;
                    }
                },
                 {
                     name: 'Identidad', "data": 'Identidad', title: "Identidad", sortable: false, searchable: false,
                     render: function (data, type, row) {
                         if (type === 'display') {
                             if (data == "1")
                                 return '<i class="fa fa-check-circle fa-lg text-success" id="ieditar" alt="si"></i>';
                             else
                                 return '<i class="fa fa-circle-o fa-lg" id="ieditar" alt="no"></i>';
                         }
                         return data;
                     }
                 },
                {
                    title: "Atributo río de datos",
                    sortable: false, searchable: false,
                    "data": 'IdAtributoRelacionado',
                    "render": function (d, t, r) {
                        var $select = $("<select class='form-control' style='width:100%' onchange='cambiarAttPectra(" + r.IdAtributo + ", this)'></select>", {
                            "id": r[0] + "start",
                            "value": d
                        });

                        var $option = $("<option></option>", {
                            "text": " -- No Asignado --",
                            "value": "0"
                        });

                        $select.append($option);

                        $.each(oAttPectra, function (k, v) {
                            var $option = $("<option></option>", {
                                "text": v.Nombre,
                                "value": v.IdAtributo
                            });
                            if (d == v.IdAtributo) {
                                $option.attr("selected", "selected")
                            }
                            $select.append($option);
                        });
                        return $select.prop("outerHTML");
                    }
                }

            ]
        });

    } catch (e) {
        showMessage(2, "Se produjo un error. Intente nuevamente.");
        $msgProcessing.hide()
    }

    FiltrarAtributos();
}

function FiltrarAtributos() {

    var idTable = $cboTablas.val();
    var positionFilter = 1;
    var regExSearch = "^" + idTable + "$"
    if (_tablaAttibutos.column(positionFilter).search() !== idTable) {
        _tablaAttibutos.column(positionFilter).search(regExSearch, true, false).draw();
    }

    mShowDataTablaAttributos = true;
    _tablaAttibutos.draw();

    $msgProcessing.hide()
}

function HandlePopupResult(result) {
    if (result == "OK")
        obtenerActividades();
}

function guardarMapeo() {

    $lblProcesandoSolicitud.html("Guardando datos..")
    $msgProcessing.show()

    var datosCambiados = JSON.stringify(_tablaAttibutos.rows().data().toArray())
    $("#DatosCambiados").val(datosCambiados);

    var param = {};
    param.datos = datosCambiados;

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/UpdateBatchAtributo",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            eestop();
            $msgProcessing.hide()
        },
        success: function (result) {
            showMessage(1, "Diccionario de datos guardado");
            eestop();
            $msgProcessing.hide()
        }
    });


}

function generarFrontEnd() {

    $('#alertContainer').hide();
    $lblProcesandoSolicitud.html("Generando y descargando aplicación.....")
    $msgProcessing.show()

    var xhr = new XMLHttpRequest();
    xhr.open('GET', "../api/fileupload/DescargarAplicacion?sidproyecto=" + $txtProyectoId.val() + "&proyectname=" + $txtProyectoName.val(), true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function () {
        if (this.status === 200) {
            var filename = "";
            var disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(disposition);
                if (matches != null && matches[1])
                    filename = decodeURIComponent(matches[1].replace(/['"]/g, ''));
            }
            var type = xhr.getResponseHeader('Content-Type');

            var blob = typeof File === 'function'
                ? new File([this.response], filename, { type: type })
                : new Blob([this.response], { type: type });
            if (typeof window.navigator.msSaveBlob !== 'undefined') {
                // IE workaround for "HTML7007: One or more blob URLs were revoked by closing the blob for which they were created. These URLs will no longer resolve as the data backing the URL has been freed."
                window.navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                var URL = window.URL || window.webkitURL;
                var downloadUrl = URL.createObjectURL(blob);

                if (filename) {
                    // use HTML5 a[download] attribute to specify filename
                    var a = document.createElement("a");
                    // safari doesn't support this yet
                    if (typeof a.download === 'undefined') {
                        window.location = downloadUrl;
                    } else {
                        a.href = downloadUrl;
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                    }
                } else {
                    window.location = downloadUrl;
                }

                setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup

            }
            eestop();
            $msgProcessing.hide()
            ObtenerZipFile();
            ObtenerLogFiles();
        }
        else {
            var uInt8Array = new Uint8Array(this.response);
            var i = uInt8Array.length;
            var binaryString = new Array(i);

            while (i--) {
                binaryString[i] = String.fromCharCode(uInt8Array[i]);
            }
            var data = binaryString.join('');
            data = decodeURIComponent(escape(data));
            showMessage(2, data);
            ObtenerLogFiles();
            eestop();
            $msgProcessing.hide()
        }
    };
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send(null);
    return;
}

function habilitarUP(estado) {
    $txtSQLUserId.prop('disabled', !estado);
    $txtSQLUserPassword.prop('disabled', !estado);
}

function retornar() {
    var url = "Default.aspx?TrxId=" + $txtTrxId.val();
    window.location = url;
}

function respaldar() {
    var param = {};
    param.sidproject = $txtProyectoId.val();
    $msgProcessing.show();
    $.ajax({
        type: "POST",
        url: "EditProject.aspx/RespaldarProyecto",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
            eestop();
            $msgProcessing.hide();
        },
        success: function (result) {
            showMessage(1, "Se ha realizado un respaldo del proyecto");
            eestop();
            $msgProcessing.hide();
        }
    });
}

function ObtenerZipFile() {
    var param = {};
    param.sidproject = $txtProyectoId.val();
    param.proyectname = $txtProyectoName.val();

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/ObtenerZipFile",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            showMessage(2, "Se produjo un error. Intente nuevamente.");
        },
        success: function (result) {
            if (result != null && result != "" && result.d != null) {
                if (JSON.parse(result.d).FileSize > 0) {
                    var archivo = JSON.parse(result.d)

                    var sDate = "--";
                    if (moment(archivo.FileDate).isValid()) {
                        sDate = moment(archivo.FileDate).format("L") + ' ' + moment(archivo.FileDate).format("HH:mm:ss");
                    }

                    var strArchivo = sDate + "  (" + archivo.FileSizeText + ")";
                    $("#txtUltimaVersionGenerada").val(strArchivo);
                    $("#divUltimaDescarga").show();
                }
            }
        }
    });
}

function ObtenerLogFiles() {

    if (isKeyAdmin() == 1) {
        ObtenerLogFile(2);
        ObtenerLogFile(3);
        ObtenerLogFile(4);
    }
}

function ObtenerLogFile(archivolog) {
    var param = {};
    param.sidproject = $txtProyectoId.val();
    param.archivo = archivolog;

    $.ajax({
        type: "POST",
        url: "EditProject.aspx/ObtenerLogFile",
        data: JSON.stringify(param),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
       // error: function (XMLHttpRequest, textStatus, errorThrown) {
       //     showMessage(2, "Se produjo un error. Intente nuevamente.");
       // },
        success: function (result) {
            if (result != null && result != "" && result.d != null) {
                if (JSON.parse(result.d).FileSize > 0) {
                    var archivo = JSON.parse(result.d)

                    var sDate = "--";
                    if (moment(archivo.FileDate).isValid()) {
                        sDate = moment(archivo.FileDate).format("L") + ' ' + moment(archivo.FileDate).format("HH:mm:ss");
                    }

                    var strArchivo = sDate + "  (" + archivo.FileSizeText + ")";

                    switch (archivolog) {
                        case 2:
                            $("#txtUltimologFrontEnd").val(strArchivo);
                            $("#divUltimologFrontEnd").show();
                            $('#btnUltimologFrontEnd').prop("disabled", true);
                            $('#btnUltimologFrontEnd').removeAttr("disabled");
                            $('#btnUltimologFrontEnd').removeClass("disabled");
                            break;
                        case 3:
                            $("#txtUltimologAPI").val(strArchivo);
                            $("#divUltimologAPI").show();
                            $('#btnUltimologAPI').prop("disabled", true);
                            $('#btnUltimologAPI').removeAttr("disabled");
                            $('#btnUltimologAPI').removeClass("disabled");
                            break;
                        case 4:
                            $("#txtUltimologPWA").val(strArchivo);
                            $("#divUltimologPWA").show();
                            $('#btnUltimologPWA').prop("disabled", true);
                            $('#btnUltimologPWA').removeAttr("disabled");
                            $('#btnUltimologPWA').removeClass("disabled");
                            break;
                    }

                }
            }
        }
    });
}



function descargarUltimaGeneracion() {
    $lblProcesandoSolicitud.html("Descargando última aplicación generada.....")
    $msgProcessing.show()
    var xhr = new XMLHttpRequest();
    xhr.open('GET', "../api/fileupload/DescargarUltimoZip?sidproyecto=" + $txtProyectoId.val() + "&proyectname=" + $txtProyectoName.val(), true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function () {
        if (this.status === 200) {
            var filename = "";
            var disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(disposition);
                if (matches != null && matches[1])
                    filename = decodeURIComponent(matches[1].replace(/['"]/g, ''));
            }
            var type = xhr.getResponseHeader('Content-Type');

            var blob = typeof File === 'function'
                ? new File([this.response], filename, { type: type })
                : new Blob([this.response], { type: type });
            if (typeof window.navigator.msSaveBlob !== 'undefined') {
                // IE workaround for "HTML7007: One or more blob URLs were revoked by closing the blob for which they were created. These URLs will no longer resolve as the data backing the URL has been freed."
                window.navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                var URL = window.URL || window.webkitURL;
                var downloadUrl = URL.createObjectURL(blob);

                if (filename) {
                    // use HTML5 a[download] attribute to specify filename
                    var a = document.createElement("a");
                    // safari doesn't support this yet
                    if (typeof a.download === 'undefined') {
                        window.location = downloadUrl;
                    } else {
                        a.href = downloadUrl;
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                    }
                } else {
                    window.location = downloadUrl;
                }

                setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
            }
        }
        $msgProcessing.hide();
    };
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send(null);

    return;
}

function descargarUltimaLog(archivo) {
    $lblProcesandoSolicitud.html("Descargando archivo de log.....")
    $msgProcessing.show()
    var xhr = new XMLHttpRequest();
    xhr.open('GET', "../api/fileupload/DescargarUltimoLog?sidproyecto=" + $txtProyectoId.val() + "&archivo=" + archivo, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function () {
        if (this.status === 200) {
            var filename = "";
            var disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(disposition);
                if (matches != null && matches[1])
                    filename = decodeURIComponent(matches[1].replace(/['"]/g, ''));
            }
            var type = xhr.getResponseHeader('Content-Type');

            var blob = typeof File === 'function'
                ? new File([this.response], filename, { type: type })
                : new Blob([this.response], { type: type });
            if (typeof window.navigator.msSaveBlob !== 'undefined') {
                // IE workaround for "HTML7007: One or more blob URLs were revoked by closing the blob for which they were created. These URLs will no longer resolve as the data backing the URL has been freed."
                window.navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                var URL = window.URL || window.webkitURL;
                var downloadUrl = URL.createObjectURL(blob);

                if (filename) {
                    // use HTML5 a[download] attribute to specify filename
                    var a = document.createElement("a");
                    // safari doesn't support this yet
                    if (typeof a.download === 'undefined') {
                        window.location = downloadUrl;
                    } else {
                        a.href = downloadUrl;
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                    }
                } else {
                    window.location = downloadUrl;
                }

                setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
            }
        }
        $msgProcessing.hide();
    };
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send(null);

    return;
}

function DescargarUltimoZip() {
    $lblProcesandoSolicitud.html("Descargando Log.....")
    $msgProcessing.show()
    var xhr = new XMLHttpRequest();
    xhr.open('GET', "../api/fileupload/DescargarLog?sidproyecto=" + $txtProyectoId.val() + "&proyectname=" + $txtProyectoName.val(), true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function () {
        if (this.status === 200) {
            var filename = "";
            var disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(disposition);
                if (matches != null && matches[1])
                    filename = decodeURIComponent(matches[1].replace(/['"]/g, ''));
            }
            var type = xhr.getResponseHeader('Content-Type');

            var blob = typeof File === 'function'
                ? new File([this.response], filename, { type: type })
                : new Blob([this.response], { type: type });
            if (typeof window.navigator.msSaveBlob !== 'undefined') {
                // IE workaround for "HTML7007: One or more blob URLs were revoked by closing the blob for which they were created. These URLs will no longer resolve as the data backing the URL has been freed."
                window.navigator.msSaveOrOpenBlob(blob, filename);
            } else {
                var URL = window.URL || window.webkitURL;
                var downloadUrl = URL.createObjectURL(blob);

                if (filename) {
                    // use HTML5 a[download] attribute to specify filename
                    var a = document.createElement("a");
                    // safari doesn't support this yet
                    if (typeof a.download === 'undefined') {
                        window.location = downloadUrl;
                    } else {
                        a.href = downloadUrl;
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();
                    }
                } else {
                    window.location = downloadUrl;
                }

                setTimeout(function () { URL.revokeObjectURL(downloadUrl); }, 100); // cleanup
            }
        }
        $msgProcessing.hide();
    };
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.send(null);

    return;
}




function initializeEditProject() {

    moment.locale('<%=System.Threading.Thread.CurrentThread.CurrentCulture.Name%>');

    $txtTrxId = $("#txtTrxId");

    $txtProyectoName = $("#txtProyectoName");
    $txtUsId = $("#txtUsId");
    $txtProyectoId = $("#txtProyectoId");

    $txtFileUploadName = $("#txtFileUploadName");
    $lblFileUploadName = $("#lblFileUploadName");

    $txtProcesoId = $("#txtProcesoId");

    $txtSQLServer = $("#txtSQLServer");
    $lblSQLServer = $("#lblSQLServer");

    $txtSQLAutenticacion_userpass = $("#txtSQLAutenticacion_userpass");
    $txtSQLUserId = $("#txtSQLUserId");
    $txtSQLUserPassword = $("#txtSQLUserPassword");

    $cboDataBases = $("#cboDataBases");
    $lblBDName = $("#lblBDName");
    $txtOrigenDeDatos = $("#txtOrigenDeDatos");
    $txtOrigenDeDatosId = $("#txtOrigenDeDatosId");

    $txtAtributosDeTablas = $("#txtAtributosDeTablas");
    $txtAtributosDePectra = $("#txtAtributosDePectra");

    $cboTablas = $("#cboTablas");

    $btnCrearProyecto = $("#btnCrearProyecto");
    $btndownloadEnabled = $("#btndownloadEnabled");
    $btndownloadDisabled = $("#btndownloadDisabled");

    $btnCrearProceso = $("#btnCrearProceso");

    $btnConectarBDServer = $("#btnConectarBDServer");
    $btnGenerarBackEnd = $("#btnGenerarBackEnd");
    $btnGenerarApp = $("#btnGenerarApp");
    $btnNuevaActividad = $("#btnNuevaActividad");
    $btnGuardarDD = $("#btnGuardarDD");

    $divDD = $("#divDD");
    $divActividades = $("#divActividades");
    $divGeneracionApp = $("#divGeneracionApp");
    $btnBackup = $("#btnBackup");


    $txtActividades = $("#txtActividades");

    $lblProcesandoSolicitud = $("#lblProcesandoSolicitud");
    $msgProcessing = $("#msgProcessing");


    if ($txtAtributosDeTablas.val() != '' && $txtAtributosDePectra.val() != '') {
        llenarTablaAtributos();
    }
    else {
        _tablaAttibutos = $("#tableAtributeMapping").DataTable();
    }

    if ($txtActividades.val() != '' && $txtActividades.val() != '') {
        llenarTablaActividades();
    }

    $("#txtSQLUserPassword").val($("#hdnSQLUserPassword").val());
    $("#hdnSQLUserPassword").val("");
    habilitarUP($txtSQLAutenticacion_userpass.prop("checked"));

    var isTouchDevice = 'ontouchstart' in document.documentElement;
    $("#iSQLUserPassword").mousedown(function (event) {
        if (isTouchDevice == false) {
            $txtSQLUserPassword.attr("type", "text")
        }
    });
    $("#iSQLUserPassword").mouseup(function (event) {
        if (isTouchDevice == false) {
            $txtSQLUserPassword.attr("type", "password")
        }
    });
    $('#iSQLUserPassword').on('touchstart', function () {
        if (isTouchDevice) {
            $txtSQLUserPassword.attr("type", "text")
        }
    });
    $('#iSQLUserPassword').on('touchend', function () {
        if (isTouchDevice) {
            $txtSQLUserPassword.attr("type", "password")
        }
    });
    if (!$txtProyectoName.prop('disabled'))
        $txtProyectoName.focus();

    ObtenerZipFile();
    ObtenerLogFiles()

    eestop();
    $msgProcessing.hide()


    $txtProyectoName.on('blur', function (event) {
        try {
            if (!isValid($txtProyectoName.val())) {
                $txtProyectoName.val("");
            }
        } catch (e) { }
    });

    var isValid = (function () {
        var rg1 = /^[^\\/:\*\?"<>\|]+$/; // forbidden characters \ / : * ? " < > |
        var rg2 = /^\./; // cannot start with dot (.)
        var rg3 = /^(nul|prn|con|lpt[0-9]|com[0-9])(\.|$)/i; // forbidden file names
        return function isValid(fname) {
            return rg1.test(fname) && !rg2.test(fname) && !rg3.test(fname);
        }
    })();

    $txtProyectoName.on("keypress", function (e) {
        if (event.which == 13) {
            crearProyecto();
        }
        var regex = new RegExp(regEx_FileName);
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (regex.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });
    $txtSQLUserPassword.on("keypress", function (e) {
        if (event.which == 13) {
            dbConectar();
        }
    });
    $("#eei").attr("src", "data:image/gif;base64,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");

    $('#mdlBDServer').on('shown.bs.modal', function () {
        $txtSQLServer.focus()
    })
};
